' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Klasa SearchCriteria jest wykorzystywana do przesylania kryteriw wyszukiwania z warstwy prezentacji przez warstw biznesow do warstwy dostepu do danych.
''' Zamiast przesya dug list poszczeglnych kryteriw wyszukiwania moesz po prostu przesa jeden obiekt eksponujcy te kryteria jako waciwoci publiczne.
''' </summary>
''' <remarks></remarks>
Public Class SearchCriteria

#Region "Zmienne prywatne"

  Private _applicationId As Integer = -1
  Private _feature As String = String.Empty
  Private _severity As String = String.Empty
  Private _status As String = String.Empty
  Private _statusType As String = String.Empty
  Private _priority As String = String.Empty
  Private _filedBy As String = String.Empty
  Private _startDate As DateTime = DateTime.MinValue
  Private _endDate As DateTime = DateTime.MinValue
  Private _keyword As String = String.Empty
  Private _bugId As Integer = -1

#End Region

#Region "Konstruktory"

  Public Sub New()

  End Sub

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Dopisuje identyfikator Feature do rozdzielonego przecinkami acucha tekstowego, ktry jest zwracany w ramach waciwoci <see cref="Feature">Feature</see>.
  ''' </summary>
  Public Sub AddFeature(ByVal theFeature As String)
    If _feature.Length > 0 Then
      theFeature = "," & theFeature
    End If
    _feature &= theFeature
  End Sub

  ''' <summary>
  ''' Dopisuje identyfikator Severity do rozdzielonego przecinkami acucha tekstowego, ktry jest zwracany w ramach waciwoci <see cref="Severity">Severity</see>.
  ''' </summary>
  Public Sub AddSeverity(ByVal theSeverity As String)
    If _severity.Length > 0 Then
      theSeverity = "," & theSeverity
    End If
    _severity &= theSeverity
  End Sub

  ''' <summary>
  ''' Dopisuje identyfikator Priority do rozdzielonego przecinkami acucha tekstowego, ktry jest zwracany w ramach waciwoci <see cref="Priority">Priority</see>.
  ''' </summary>
  Public Sub AddPriority(ByVal thePriority As String)
    If _priority.Length > 0 Then
      thePriority = "," & thePriority
    End If
    _priority &= thePriority
  End Sub

  ''' <summary>
  ''' Dopisuje identyfikator Status do rozdzielonego przecinkami acucha tekstowego, ktry jest zwracany w ramach waciwoci <see cref="Status">Status</see>.
  ''' </summary>
  Public Sub AddStatus(ByVal theStatus As String)
    If _status.Length > 0 Then
      theStatus = "," & theStatus
    End If
    _status &= theStatus
  End Sub

  ''' <summary>
  ''' Dopisuje identyfikator Member do rozdzielonego przecinkami acucha tekstowego, ktry jest zwracany w ramach waciwoci <see cref="FiledBy">FiledBy</see>.
  ''' </summary>
  Public Sub AddFiledBy(ByVal filedBy As String)
    If _filedBy.Length > 0 Then
      filedBy = "," & filedBy
    End If
    _filedBy &= filedBy
  End Sub

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Zwraca ApplicationId.
  ''' </summary>
  Public Property ApplicationId() As Integer
    Get
      Return _applicationId
    End Get
    Set(ByVal value As Integer)
      _applicationId = value
    End Set
  End Property

  ''' <summary>
  ''' Zwraca rozdzielon przecinkami list identyfikatorw Feature.
  ''' </summary>
  Public ReadOnly Property Feature() As String
    Get
      Return _feature
    End Get
  End Property

  ''' <summary>
  ''' Zwraca rozdzielon przecinkami list identyfikatorw Severity.
  ''' </summary>
  Public ReadOnly Property Severity() As String
    Get
      Return _severity
    End Get
  End Property

  ''' <summary>
  ''' Zwraca rozdzielon przecinkami list identyfikatorw Status.
  ''' </summary>
  Public ReadOnly Property Status() As String
    Get
      Return _status
    End Get
  End Property

  ''' <summary>
  ''' Zwraca StatusType
  ''' </summary>
  ''' <remarks>StatusType moe mie warto Active, Inactive lub by pustym acuchem tekstowym.</remarks>
  Public Property StatusType() As String
    Get
      Return _statusType
    End Get
    Set(ByVal value As String)
      _statusType = value
    End Set
  End Property

  ''' <summary>
  ''' Zwraca rozdzielon przecinkami list wartoci Priority.
  ''' </summary>
  Public ReadOnly Property Priority() As String
    Get
      Return _priority
    End Get
  End Property

  ''' <summary>
  ''' Zwraca rozdzielon przecinkami list identyfikatorw Member.
  ''' </summary>
  Public ReadOnly Property FiledBy() As String
    Get
      Return _filedBy
    End Get
  End Property

  ''' <summary>
  ''' Zwraca dat rozpoczcia.
  ''' </summary>
  Public Property StartDate() As DateTime
    Get
      Return _startDate
    End Get
    Set(ByVal value As DateTime)
      _startDate = value
    End Set
  End Property

  ''' <summary>
  ''' Zwraca dat zakoczenia.
  ''' </summary>
  Public Property EndDate() As DateTime
    Get
      Return _endDate
    End Get
    Set(ByVal value As DateTime)
      _endDate = value
    End Set
  End Property

  ''' <summary>
  ''' Zwraca sowo kluczowe Keyword.
  ''' </summary>
  Public Property Keyword() As String
    Get
      Return _keyword
    End Get
    Set(ByVal value As String)
      _keyword = value
    End Set
  End Property

  ''' <summary>
  ''' Zwraca BugId.
  ''' </summary>
  Public Property BugId() As Integer
    Get
      Return _bugId
    End Get
    Set(ByVal value As Integer)
      If value < 1 Then
        Throw New ArgumentException("Warto Bug Id musi byc wiksza ni 0")
      End If
      _bugId = value
    End Set
  End Property

#End Region

End Class
